<section>
    <div class="container bg-light pt-5 rounded-4 mb-3">
        <div class="row justify-content-center">
            <div class="col-12 col-lg-9">
				<?= $this->Form->create($menu, ['enctype' => 'multipart/form-data', 'class'=>'form-horizontal row-fluid']) ?>

                <div class="row mb-3">
                    <label for="name" class="col-sm-2 col-xs-12 field-label fw-semibold">Name *</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('name', [
                            'id' => 'name',
                            'class' => 'form-control',
                            'label' => false,
                            'required' => true
                        ]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="description" class="col-sm-2 col-xs-12 field-label fw-semibold">Description *</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('description', [
                            'id' => 'description',
                            'class' => 'form-control',
                            'label' => false,
                            'required' => true
                        ]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="show_on_home" class="col-sm-2 col-xs-12 field-label fw-semibold">Show on Home</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('show_on_home', [
                            'id' => 'show_on_home',
                            'class' => 'form-select',
                            'options' => [1 => 'Yes', 0 => 'No'],
                            'label' => false
                        ]); ?>
                    </div>
                </div>

                <!-- Dynamic Content Builder -->
                <!-- <.?php $contentBlocks = json_decode($menu->content, true); ?>
                <div class="row mb-3">
                    <label class="col-sm-2 col-xs-12 field-label fw-semibold">Content Builder</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <div id="content-builder" class="border rounded p-3 mb-2 bg-light"></div>
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-sm btn-outline-primary"
                                onclick="addBlock('paragraph')">Add
                                Paragraph</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary"
                                onclick="addBlock('list')">Add
                                List</button>
                        </div>
                        <.?= $this->Form->hidden('content', ['id' => 'content_json']) ?>
                    </div>
                </div> -->

                <div class="row mb-3">
                    <label for="fa_icon" class="col-sm-2 col-xs-12 field-label fw-semibold">Icon Class</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('fa_icon', [
                            'id' => 'fa_icon',
                            'class' => 'form-control',
                            'label' => false
                        ]); ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label for="image_path" class="col-sm-2 col-xs-12 field-label fw-semibold">Upload Image</label>
                    <div class="col-sm-10 col-xs-12 text-input mb-3">
                        <?= $this->Form->control('image_path', [
                            'id' => 'image_path',
                            'type' => 'file',
                            'class' => 'form-control',
                            'label' => false
                        ]); ?>
                        <?= $this->Form->hidden('old_image', [
                            'value' => $menu->image_path ?? '',
                            'label' => false
                        ]); ?>
                    </div>
                </div>

                <?php if (!empty($menu->image_path)): ?>
                    <div class="row mb-3">
                        <label class="col-sm-2 col-xs-12 field-label fw-semibold">Current Image</label>
                        <div class="col-sm-10 col-xs-12 text-input mb-3">
                            <div class="border p-2">
                                <?= $this->Html->image(Cake\Core\Configure::read('IMAGE_PREPATH') . $menu->image_path, [
                                    'class' => 'img-fluid rounded',
                                    'style' => 'max-height: 150px;'
                                ]) ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                        <div class="row">
                        <div class="col-md-12 col-sm-12 d-flex justify-content-end align-items-end my-4">
                            <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary pull-right']) ?>
                        </div>
                    </div>
                    <?php $this->Form->end()?>
            </div>
        </div>
    </div>
</section>


<!-- <script>
    function addBlock(type, label = '', content = '') {
        const container = $('#content-builder');

        let blockHtml = '';
        if (type === 'paragraph') {
            blockHtml = `
            <div class="content-block mb-3" data-type="paragraph">
                <div class="d-flex justify-content-between mb-2">
                    <input type="text" class="form-control label-input me-2" placeholder="Label (optional)" value="${label}">
                    <button type="button" class="btn btn-sm btn-danger" onclick="$(this).closest('.content-block').remove()">Remove</button>
                </div>
                <textarea class="form-control content-input" placeholder="Paragraph text">${content}</textarea>
            </div>`;
        } else if (type === 'list') {
            blockHtml = `
            <div class="content-block mb-3" data-type="list">
                <div class="d-flex justify-content-between mb-2">
                    <input type="text" class="form-control label-input me-2" placeholder="Label (optional)" value="${label}">
                    <button type="button" class="btn btn-sm btn-danger" onclick="$(this).closest('.content-block').remove()">Remove</button>
                </div>
                <textarea class="form-control list-input" placeholder="Enter list items, one per line">${content}</textarea>
            </div>`;
        }

        container.append(blockHtml);
    }

    // Load existing blocks from PHP into builder
    $(document).ready(function () {
        const contentBlocks = <?= json_encode($contentBlocks ?? []) ?>;
        contentBlocks.forEach(block => {
            if (block.type === 'paragraph') {
                addBlock('paragraph', block.label || '', block.content || '');
            } else if (block.type === 'list') {
                const listContent = (block.items || []).join('\n');
                addBlock('list', block.label || '', listContent);
            }
        });
    });

    // On form submit, collect blocks into JSON
    $('form').on('submit', function () {
        const blocks = [];

        $('#content-builder .content-block').each(function () {
            const type = $(this).data('type');
            const label = $(this).find('.label-input').val();

            if (type === 'paragraph') {
                const content = $(this).find('.content-input').val();
                blocks.push({ type, label, content });
            } else if (type === 'list') {
                const rawItems = $(this).find('.list-input').val();
                const items = rawItems.split('\n').map(i => i.trim()).filter(i => i);
                blocks.push({ type, label, items });
            }
        });

        $('#content_json').val(JSON.stringify(blocks));
    });
</script> -->